function setHpsParams(bv)
%SETHPSPARAMS Modify parameters for a greenhouse crop model based on Vanthoor (2011), according to a dataset with HPS toplighting 
% Note that this has not been fully calibrated yet, so still a work in progress.
% Inputs:
%   bv   - a StateSpaceModel object to be used as a Vanthoor model
%
% Based on:
%   [1] Dueck, T., Janse, J., Schapendonk, A. H. C. M., Kempkes, F., 
%       Eveleens, B., Scheffers, K., [...] Marcelis, L. F. M. (2010). 
%       Lichtbenuttig van tomaat onder LED en SON-T belichting. Wageningen.
%   [2] Dueck, T., Janse, J., Eveleens, B. A., Kempkes, F. L. K., 
%       & Marcelis, L. F. M. (2012). Growth of Tomatoes under Hybrid LED 
%       and HPS Lighting. Acta Horticulturae, 1(952), 335342. 
%       Retrieved from http://edepot.wur.nl/216929
%   [3] Nelson, J. A., & Bugbee, B. (2015). Analysis of Environmental Effects 
%       on Leaf Temperature under Sunlight, High Pressure Sodium and Light 
%       Emitting Diodes. PLOS ONE, 10(10), e0138930. 
%       https://doi.org/10.1371/journal.pone.0138930

% David Katzin, Wageningen University
% david.katzin@wur.nl

    setParam(bv, 'psi', 23); 					% Mean greenhouse cover slope 																	 						25 [1]
    setParam(bv, 'aFlr', 144);                  % Floor area of greenhouse 																		m^{2} 					1.4e4 [1]
    setParam(bv, 'aCov', 216.6);              % Surface of the cover including side walls 													m^{2} 					1.8e4 [1]
    setParam(bv, 'hAir', 5.7);                  % Height of the main compartment 																m 						3.8 [1]
    setParam(bv, 'hGh', 6.2);                   % Mean height of the greenhouse 																m 						4.2 [1]
    
    setParam(bv, 'aRoof', 52.2);                % Maximum roof ventilation area 																- 						0.1*aFlr [1]
    setParam(bv, 'hVent', 0.87);                % Vertical dimension of single ventilation opening 												m 						0.68 [1]
    setParam(bv, 'cLeakage', 0.3e-4); 			% Leakage coefficient 																			- 						1e-4 [1]
    
    setParam(bv, 'tauRfNir', 0.57); 			% NIR transmission coefficient of the roof 														- 						0.68 [11]
    setParam(bv, 'tauRfPar', 0.57);  			% PAR transmission coefficient of the roof 														- 						0.68 [11]
    setParam(bv, 'tauThScrPar', 0.75); 			% PAR transmission coefficient of thermal screen 												- 						0.6 [1]
    setParam(bv, 'phiPipeI', (51e-3)-(2.25e-3));% Internal diameter of pipes 																	m 						47e-3 [1]
    setParam(bv, 'lPipe', 1.3375); 			% Length of heating pipes per gh floor area 													m m^{-2} 				1.875 [1]
    setParam(bv, 'pBoil', 44*bv.p.aFlr.val);    % Capacity of the heating system                                                                W                       88*p.aFlr (Assumed to be 88 W m^{-2}) [5]
    setParam(bv, 'phiExtCo2', 720);             % Capacity of external CO2 source 																mg s^{-1} 				7.2e4 [1] (for 1.4e4 m^{2}) 2.778 mg s^{-1} m^{-2} [5]
    
    setParam(bv, 'epsGroPipe', 0.88);              % Emissivity of grow pipes                                                                  [-]                                     0 (no grow pipes)
    setParam(bv, 'lGroPipe', 1.655); 			% Length of grow pipes per gh floor area                                                    m m^{-2}                                1.25 (Arjan Vervoort thesis, from [8]?)
    setParam(bv, 'phiGroPipeE', 35e-3); 		% External diameter of grow pipes 															m                                       28e-3 [8]
    setParam(bv, 'phiGroPipeI', (35e-3)-(1.2e-3));% Internal diameter of grow pipes 														m                                       24e-3 (Assumed to be 4e-3 less than phiGroPipeE, but check)
    
    setParam(bv, 'pGroBoil', 44*bv.p.aFlr.val); % Capacity of the grow pipe heating system                                                      W                                       88*p.aFlr (Assumed to be same as pipe rail, but actually based on [5] pBoil+pGroBoil should be 88) 
    
    %% Lamp parameters
    % HPS
    setParam(bv, 'lampsMax', 110);                  % Maximum intensity of lamps																	[W m^{-2}]                              Pg. 48 [1] (measured capacity divided by 144 m2)
    setParam(bv, 'heatCorrection', 0);   			% correction for temperature setpoint when lamps are on 										[C]   									0
    setParam(bv, 'etaLampPar', 0.36);                % fraction of lamp input converted to PAR 														[-]                                     [3] gives 0.34 with a lamp of 1.7 umol/J. This lamp is 1.8 umol/J [2], i.e. 6% more efficient as the one in [3]
    setParam(bv, 'etaLampNir', 0.22);               % fraction of lamp input converted to NIR 														[-]                                     [3]   
    setParam(bv, 'tauLampPar', 0.97);              % transmissivity of lamp layer to PAR 															[-]                                     Pg. 22 [1] (light loss due to armatures)
    setParam(bv, 'rhoLampPar', 0);                  % reflectivity of lamp layer to PAR 															[-]                                     0 [7]
    setParam(bv, 'tauLampNir', 0.97);              % transmissivity of lamp layer to NIR 															[-]                                     Pg. 22 [1] (light loss due to armatures)
    setParam(bv, 'rhoLampNir', 0);                  % reflectivity of lamp layer to NIR 															[-]                                     0 [7]
    setParam(bv, 'tauLampFir', 0.97);              % transmissivity of lamp layer to FIR 															[-]                                     Pg. 22 [1] (light loss due to armatures)
    setParam(bv, 'aLamp', 0.03);                   % lamp area 																					[m^{2}{lamp} m^{-2}{floor}]                 Pg. 22 [1] (light loss due to armatures)
    setParam(bv, 'epsLampTop', 0.1);                % emissivity of top side of lamp 																[-]                                     
    setParam(bv, 'epsLampBottom', 0.9);             % emissivity of bottom side of lamp 															[-]                                     
    setParam(bv, 'capLamp', 100);                   % heat capacity of lamp 																		[J K^{-1} m^{-2}]                       
    setParam(bv, 'hecLampAir', 0.09);               % heat exchange coefficient of lamp                                                             [W m^{-2} K^{-1}]                       
    setParam(bv, 'lampCool', 0);                    % fraction of lamp input removed by cooling                                                     [-]                                     0 (No cooling)
    setParam(bv, 'parJtoUmolLamp', 5);           % J to umol conversion of PAR output of lamp                                                    [umol{PAR} J^{-1}]                 Efficacy of 1.8 umol/J [2], divided by 0.36 fraction to PAR (see above)      
    
    setParam(bv, 'leakTop', 0.9);               % Fraction of leakage ventilation going from the top                                            [-]                                     0.5 [1]
    
    % Reset other parameters that may depend on parameters changed above
    setDepParams(bv);    
end

